/**
 * 调用通用组件
 */
new KS_Main();

/**
 * 标题配置
 */
function setPageTitle(parameter){
	if(typeof parameter === 'string'){
		parameter = {
			title:parameter
		}
	}
	var title = parameter.title;
	var $header = $('#header');
	$header.find('.text').html(title);
	$header.find('.backicon').click(function(){
		
		history.back(-1)
	});
	if(parameter.search){
		$header.find('.listicon').before('<div class="scicon" onclick="location.href=\''+parameter.search+'\'"></div>')
	}
	
};

/**
 * 打开链接
 */
function openUrl(url){
	if(url){
		/**
		 * 将上一页地址存入本地缓存
		 */
		localStorage.backUrl = location.href;
		location.href = url;
	}else if(localStorage.backUrl){
		/**
		 * 打开本地缓存的链接
		 */
		var backUrl = localStorage.backUrl;
		localStorage.backUrl = '';
		location.href = backUrl;
		
	}
}

 
/**
 * 设置个人中心头部
 */
function setUserPageTitle(title){
	setPageTitle({
		title:title
	})
};

/**
 * 打开页面
 */
function openNewPage(id){
	var $page = $('#'+id);
	var $default = $('page-default');
	$page.attr('style','display:block;width:100%;height:100%;position:fixed;right:-'+window.innerWidth+'px;top:0;z-index:9999;').animate({
		right:0
	},400);
	$page.find('[page-fixed]').css({
		left:'inherit',
		right:-window.innerWidth
	}).animate({
		right:0
	},400)
	$default.find('[page-fixed]').animate({
		left:-window.innerWidth
	},400);
	$default.animate({
		left:-window.innerWidth
	},400,function(){
		$default.hide()
		$page.attr('style','display:block')
	})
}

/**
 * 关闭页面
 */
function closePage(id){
	var $page = $('#'+id);
	var $default = $('page-default');
	$page.animate({
		right:-window.innerWidth
	},400);
	$page.find('[page-fixed]').animate({
		right:-window.innerWidth
	},400)
	$default.attr('style','display:block;width:100%;height:100%;position:fixed;left:-'+window.innerWidth+'px;top:0;z-index:9999;').animate({
		left:0
	},400);
	$default.find('[page-fixed]').animate({
		left:0
	},400,function(){
		$page.hide();
		$default.attr('style','display:block')
	});
}

/**
 * 搜索
 */
function gosearch(){
	var key_el = document.getElementById('search_key');
	if(key_el && !key_el.value.replace(/\s+/)){
		alert('请输入关键词')
		key_el.value = '';
		key_el.focus();
		return false
	}
}

/**
 * 创建swiper
 */
function setSwiper(el,parameter){
	new Swiper(el, parameter);
	var $el = $(el);
	var $curel = $el.find('.curr');
	var x = $curel.offset().left + $curel.width() - window.innerWidth;
	var nextLength = $curel.nextAll('li').length;
	if(nextLength >= 2){
		x += $curel.width() * 2;
	}else if(nextLength >= 1){
		x += $curel.width();
	}
	x = Math.max(x,0);
	$el.find('.swiper-wrapper').css({
		transform:'translate3d(-'+x+'px, 0px, 0px)'
	})
}

(function(){
	
	
	var $asideclick = $('#asideclick'),
		$asidebg = $('#asidebg'),
		$asidemenu = $('#asidemenu'),
		scrollFlag = true;
	/**
	 * 打开侧边栏
	 */
	$asideclick.click(function(){
		$asidebg.fadeIn(300);
		scrollFlag = false;
		$('body').css('overflow','hidden');
		$asidemenu.css({
			display:'block',
			right:'-100%'
		}).animate({
			right:0
		},300)
	});
	$asidebg.click(function(){
		$(this).fadeOut(300);
		scrollFlag = true;
		$('body').css('overflow','');
		$asidemenu.animate({
			right:'-100%'
		},300,function(){
			$(this).hide();
			
		})
	});

	$('scroll-view').on('touchmove',function(e){
		e.stopPropagation()
	});
	
	$(window).on('touchmove', function(event) {
		!scrollFlag && event.preventDefault();

	});
	$(window).resize(function(){
		$('#aside_scroll').height(window.innerHeight - $('#goUserIndex').height() - $('.gk-cart').height())
		$('[page-fixed]').width(window.innerWidth)
	}).resize();
	/**
	 * 获取用户信息
	 */
	var $el = $('#goUserIndex');
	getUserInfo(function(res){
		
		$el.find('.face').html('<img src="/UploadFiles/avatar/' + res.userid + '.jpg" onerror="replaceDefaultImg(this)" type="user" />');
		$el.find('.name span').html(res.username);
		$el.find('.message').html(res.message)
		if(res.message > 0){
			$el.find('.listicon').html('<div class="ybg"></div>')
		}
		$el.attr('onclick','location.href=\'/user\'')
	},function(res){
		$el.attr('onclick','location.href=\''+res.url_login+'\'')
	});

	/**
	 * SQL标签异步赋值
	 */
	$('.SQL_async').each(function(){
		this.outerHTML = this.value
	})

	var navel = document.querySelector('.tytab') || document.querySelector('.SchoolNav')
	if(navel){
		
		var $navel = $(navel);
		var $curel = $navel.find('.curr');
		var x = $curel.offset().left + $curel.width() - window.innerWidth;
		var nextLength = $curel.nextAll('li').length;
		if(nextLength >= 2){
			x += $curel.width() * 2;
		}else if(nextLength >= 1){
			x += $curel.width();
		}
		x = Math.max(x,0);
		$navel.find('.swiper-wrapper').css({
			transform:'translate3d(-'+x+'px, 0px, 0px)'
		})
	}

	
	var oldIndex = -1,
		$filertbox = $(".filertbox"),
		$myfilert = $("#myfilert"),
		$myfilertbg = $("#myfilertbg");
	/**
	 * 分类下拉
	 */
	$filertbox.on('click','dt',function(){
		var i = $(this).index();
		if(i!=oldIndex){
			oldIndex = i;
			$(this).addClass('curr').siblings().removeClass('curr')
			$(this).find('.ksicon').addClass("iconrotate");
			$(this).siblings().find('.ksicon').removeClass("iconrotate");
			$myfilertbg.fadeIn(300)
			$myfilert.find(".box:eq("+i+")").fadeIn(300).siblings().hide();
			
		}else{
			closeFilert();
			oldIndex = -1;
		};
	});
	$myfilertbg.click(function(){
	   closeFilert();
	});
	
	function closeFilert(){
		$filertbox.find('dt').removeClass('curr');
	    $filertbox.find('.ksicon').removeClass("iconrotate");
		$myfilertbg.fadeOut(300)
		$myfilert.find(".box").fadeOut(300);
		
	};
	/**
	 * 获取选中信息
	 */
	$myfilert.find('.box').each(function(index) {
        var currText = $(this).find(".curr").text();
		var type = $(this).find('li').attr('field');
		if(type=='price_member' && (currText == '不限' || currText=='')){
			currText = $filertbox.find('dt').eq(index).find('span').text();
		};
		$filertbox.find('dt').eq(index).find('span').html(currText);
		
	});
})();
